#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/memory_map_option.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/version.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/fbs/traffic_sign_groups.fbs64.h>

#include <string>
#include <vector>

namespace maps::mrc::fb {

class TrafficSignGroupsReader {
public:
    explicit TrafficSignGroupsReader(const std::string& fromDirectory,
                                     EMappingMode = EMappingMode::Standard);

    std::string_view version() const;

    size_t groupsNumber() const;

    /// @param offset in range [0, groupsNumber).
    const TrafficSignGroup* group(size_t offset) const;

    const TrafficSignGroup* groupById(db::TId) const;

private:
    const TBlob storage_;
    const TrafficSignGroups* trafficSignGroups_;
};

}  // namespace maps::mrc::fb
