#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/fb_rtree/include/rtree.h>

#include <optional>
#include <string>

namespace maps::mrc::fb {

class WalkObjectsReader {
public:
    explicit WalkObjectsReader(const std::string& fromDirectory,
                               EMappingMode = EMappingMode::Standard);
    std::string_view version() const;
    size_t walkObjectsNumber() const;

    /// @param offset in range [0, walkObjectsNumber).
    db::TId id(size_t offset) const;
    geolib3::Point2 pos(size_t offset) const;

    std::optional<geolib3::Point2> posByWalkObjectId(db::TId id) const;

    const fb_rtree::Rtree& rtree() const { return rtree_; };

private:
    const TBlob storage_;
    const WalkObjects* walkObjects_;
    const fb_rtree::Rtree rtree_;
};

}  // namespace maps::mrc::fb
