#pragma once

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>
#include <maps/libs/road_graph/include/graph.h>
#include <maps/libs/succinct_rtree/include/rtree.h>

namespace maps::mrc::fb::tests {

const std::string GRAPH_PATH = BinaryPath("maps/data/test/graph3");

const std::string TEST_PATH =
    BinaryPath("maps/wikimap/mapspro/services/mrc/libs/fb/tests");

inline const road_graph::Graph& roadGraph()
{
    static const auto result = road_graph::Graph(GRAPH_PATH + "/road_graph.fb");
    return result;
}

inline const succinct_rtree::Rtree& rtree()
{
    static const auto result =
        succinct_rtree::Rtree(GRAPH_PATH + "/rtree.fb", roadGraph());
    return result;
}

}  // namespace maps::mrc::fb::tests
