#pragma once

#include "node.h"

#include <maps/libs/geolib/include/bounding_box.h>

#include <boost/iterator/iterator_facade.hpp>

#include <stack>
#include <vector>

namespace maps::mrc::fb_rtree {

class Rtree;

namespace impl {

// Allows to iterate through all IDs intersecting with the given bounding box
class BboxIterator
    : public boost::
          iterator_facade<BboxIterator, Id, std::forward_iterator_tag, Id> {
public:
    BboxIterator(const Rtree*, const geolib3::BoundingBox&, IntersectsWithId);
    BboxIterator() = default;
    bool equal(const BboxIterator&) const;
    Id dereference() const;
    void increment();

private:
    const Rtree* rtree_;
    geolib3::BoundingBox bbox_;
    IntersectsWithId intersectsWithId_;
    std::stack<Node> innerNodes_;
    Ids results_;

    void findNextResult();
    void onNewNode(const Node&);
};

}  // namespace impl
}  // namespace maps::mrc::fb_rtree
