#pragma once

#include "common.h"
#include "node.h"

#include <maps/libs/geolib/include/point.h>

#include <boost/iterator/iterator_facade.hpp>

#include <queue>
#include <variant>

namespace maps::mrc::fb_rtree {

class Rtree;

namespace impl {

class NearestIterator
    : public boost::
          iterator_facade<NearestIterator, Id, std::forward_iterator_tag, Id> {
public:
    NearestIterator(const Rtree*,
                    const geolib3::Point2&,
                    DistanceToBox,
                    DistanceToId);

    NearestIterator() = default;
    bool equal(const NearestIterator&) const;
    Id dereference() const;
    void increment();

private:
    struct Entry {
        std::variant<Id, Node> object;
        double distance;

        // Priority queue order is descending. Since we want the nodes with
        // least distance to go first, we need to inverse the relation here
        bool operator<(const Entry& other) const
        {
            return distance > other.distance;
        }
    };

    const Rtree* rtree_;
    geolib3::Point2 point_;
    DistanceToBox distanceToBox_;
    DistanceToId distanceToId_;
    std::priority_queue<Entry> queue_;

    bool hasObject() const;
    void findNextResult();
    void onNewNode(const Node&);
};

}  // namespace impl
}  // namespace maps::mrc::fb_rtree
