#include "compact_bbox.h"
#include "node.h"
#include "rtree_view.h"

#include <util/generic/xrange.h>

namespace maps::mrc::fb_rtree::impl {

RtreeView::RtreeView(size_t branching,
                     OffsetVarWidthVectorReader levelBegin,
                     const fb::CompactBoundingBox* nodes)
    : branching_(branching), levelBegin_(levelBegin), nodes_(nodes)
{
}

void RtreeView::forEachDirectChild(
    const Node& node,
    std::function<void(const Node&)> callback) const
{
    auto nextLevelBegin = node.level > 0 ? levelBegin_[node.level - 1] : 0;
    auto [childrenBegin, childrenEnd] = childrenRange(node);
    for (const auto child : xrange(childrenBegin, childrenEnd)) {
        auto childBbox = uncompact(nodes_[nextLevelBegin + child], node.bbox);
        callback({childBbox, node.level + 1, child, node.rtree, std::nullopt});
    }
}

std::pair<size_t, size_t> RtreeView::childrenRange(const Node& node) const
{
    auto nextLevelBegin = node.level > 0 ? levelBegin_[node.level - 1] : 0;
    size_t nextLevelSize = levelBegin_[node.level] - nextLevelBegin;
    return {node.index * branching_,
            std::min((node.index + 1) * branching_, nextLevelSize)};
}

}  // namespace maps::mrc::fb_rtree::impl
