#pragma once

#include "offset_var_width_vector_reader.h"

#include <maps/wikimap/mapspro/services/mrc/libs/fb_rtree/storage.fbs64.h>

#include <functional>
#include <utility>

namespace maps::mrc::fb_rtree {

struct Node;

namespace impl {

//  * We don't explicitly store root node here. It's good only for its bounding
//      box because we already know that it would have level = 0, index = 0.
//  * We don't store first two values in levelBegin because they are always
//      the same: 0 and 1. This means that indices in levelBegin are shifted
//      by 2.
class RtreeView {
public:
    RtreeView(size_t branching,
              OffsetVarWidthVectorReader levelBegin,
              const fb::CompactBoundingBox* nodes);

    void forEachDirectChild(const Node&,
                            std::function<void(const Node&)>) const;

    // Range for the children indices on the next level
    std::pair<size_t, size_t> childrenRange(const Node&) const;

    size_t height() const { return levelBegin_.size; }

private:
    size_t branching_;
    OffsetVarWidthVectorReader levelBegin_;
    const fb::CompactBoundingBox* nodes_;
};

}  // namespace impl
}  // namespace maps::mrc::fb_rtree
