#pragma once

#include "common.h"
#include "rtree_view.h"

#include <maps/libs/geolib/include/bounding_box.h>

#include <optional>

namespace maps::mrc::fb_rtree {

struct Node {
    geolib3::BoundingBox bbox;
    size_t level;                          ///< numbered from root going down
    size_t index;                          ///< within the level of the rtree
    std::optional<impl::RtreeView> rtree;  ///< when we can go any deeper
    std::optional<Id> id;
};

}  // namespace maps::mrc::fb_rtree
