#pragma once

#include "rtree.h"

#include <maps/libs/geolib/include/bounding_box.h>

#include <string>
#include <vector>

namespace maps::mrc::fb_rtree {

struct LeafNode {
    Id id;
    geolib3::BoundingBox bbox;
};

using LeafNodes = std::vector<LeafNode>;

void packRtree(const std::string& version,
               LeafNodes /* sink */,
               const std::string& outputFilename,
               size_t branching = 5);

/// @brief Build in-memory Rtree
std::unique_ptr<Rtree> buildRtree(const std::string& version,
                                  LeafNodes /* sink */,
                                  size_t branching = 5);

TBuffer buildRtreeToBuffer(const std::string& version,
                           LeafNodes /* sink */,
                           size_t branching = 5);

}  // namespace maps::mrc::fb_rtree
