#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/graph/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/graph/include/id.h>

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/condition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/rd.h>

#include <map>
#include <set>
#include <unordered_map>
#include <vector>

namespace maps::mrc::graph {

// Road condition is a chain of two or more road elements.
// This class define sequence position of road element at condition with appropriate id.
struct ConditionPosition {
    ConditionPosition(TId conditionId, size_t position)
        : conditionId(conditionId)
        , position(position)
    {}

    TId conditionId;
    size_t position;
};

using ConditionPositions = std::vector<ConditionPosition>;
using ConditionPositionsByDirectedId = std::map<DirectedId, ConditionPositions>;

class ConditionIndex {

public:
    ConditionIndex(
            AccessId accessId,
            const RoadElements& elements,
            const Conditions& conditions);

    // Check that a u-turn is possible at node which is matched to element direction.
    bool isUturnAllowed(const DirectedId& elementDirectedId) const;

    // Condition is a sequence of road elements (direction is taken in account).
    // This function checks that there is some forbidden condition,
    // which element sequence is suffix of trace.
    bool hasForbiddenConditionAsSuffix(const Trace& trace) const;

    // Condition is asequence of road elements (direction is taken in account).
    // For each forbidden condition there is longest prefix, which is the suffix of the trace.
    // Returns the longest one.
    Trace longestSuffixForbiddenConditionPrefix(const Trace& trace) const;

private:
    ConditionPositionsByDirectedId forbiddenConditionPositionsByDirectedId_;
    std::unordered_map<TId, Trace> forbiddenTraceByConditionId_;
    std::set<DirectedId> isUturnAllowed_;
};

} // namespace maps::mrc::graph
