#include <maps/wikimap/mapspro/services/mrc/libs/graph/impl/trace_index.h>

namespace maps::mrc::graph {

NodeId TraceIndex::nodeId(const Trace& trace)
{
    const auto [it, inserted] = index_.emplace(trace, traces_.size());

    if (inserted) {
        traces_.push_back(it);
    }

    return it->second;
}

bool TraceIndex::has(const Trace& trace) const { return index_.count(trace); }

const Trace& TraceIndex::trace(TId index) const {
    REQUIRE(
        index < static_cast<TId>(traces_.size()),
        "There is no traced id with index" << index
    );

    return traces_.at(index)->first;
}

} // namespace maps::mrc::graph
