#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/graph/include/id.h>

#include <map>
#include <vector>

namespace maps::mrc::graph {

class TraceIndex {

public:
    NodeId nodeId(const Trace& trace);

    const Trace& trace(TId index) const;

    bool has(const Trace& trace) const;

private:
    using Index = std::map<Trace, NodeId>;

    Index index_;
    std::vector<Index::const_iterator> traces_;
};

} // namespace maps::mrc::graph
