#pragma once

#include "utility.h"

#include <maps/analyzer/libs/data/include/gpssignal.h>
#include <maps/wikimap/mapspro/services/mrc/libs/graph_matcher_adapter/include/matcher.h>

#include <boost/date_time/posix_time/posix_time_types.hpp>

namespace maps::mrc::adapters {

chrono::TimePoint fromBoost(const boost::posix_time::ptime&);

boost::posix_time::ptime toBoost(const chrono::TimePoint&);

/// uniform motion along the way
TrackSegments makePath(chrono::TimePoint startTime,
                       chrono::TimePoint endTime,
                       const TrackSegments&);

analyzer::data::GpsSignal toGpsSignal(const db::TrackPoint&);

void sortUniqueByTime(db::TrackPoints&);

}  // namespace maps::mrc::adapters
