#pragma once

#include <maps/analyzer/libs/graphmatching/include/configs.h>
#include <maps/libs/road_graph/include/graph.h>
#include <maps/libs/succinct_rtree/include/rtree.h>
#include <maps/wikimap/mapspro/services/mrc/libs/graph_matcher_adapter/include/matcher.h>

namespace maps::mrc::adapters {

/**
 * @brief match gps track to maps edges
 * using maps/analyzer/libs/graphmatching library
 */
class CompactGraphMatcherAdapter : public Matcher {
public:
    explicit CompactGraphMatcherAdapter(
        const std::string& graphFolder = GRAPH_FOLDER,
        const std::string& matcherConfigFile = MATCHER_CONFIG_RESOURCE,
        EMappingMode mappingMode = EMappingMode::Standard);

    TrackSegments match(db::TrackPoints trackPoints) const override;

    std::string graphVersion() const override;

    const road_graph::Graph& graph() const { return graph_; }

    const succinct_rtree::Rtree& rtree() const { return rtree_; };
    
private:
    road_graph::Graph graph_;
    succinct_rtree::Rtree rtree_;
    analyzer::graphmatching::MatcherConfig config_;
};

}  // namespace maps::mrc::adapters
