#pragma once

#include <maps/analyzer/libs/graphmatching/conf/paths.h>
#include <maps/libs/chrono/include/time_point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/db/include/track_point.h>
#include <maps/libs/geolib/include/segment.h>

#include <maps/libs/road_graph/include/types.h>

#include <string>
#include <vector>

namespace maps::mrc::adapters {

struct TrackSegment {

    TrackSegment(
        geolib3::Segment2 segment_,
        chrono::TimePoint startTime_,
        chrono::TimePoint endTime_,
        std::optional<road_graph::EdgeId> edgeId_ = std::nullopt
    )
        : segment(std::move(segment_))
        , startTime(startTime_)
        , endTime(endTime_)
        , edgeId(edgeId_)
    {}

    geolib3::Segment2 segment;
    chrono::TimePoint startTime;
    chrono::TimePoint endTime;
    // edgeId exists if the track segment is the result of matching on graph
    std::optional<road_graph::EdgeId> edgeId{};
};

using TrackSegments = std::vector<TrackSegment>;

static const std::string GRAPH_FOLDER = "/usr/share/yandex/maps/graph";
static const std::string MATCHER_CONFIG_RESOURCE = maps::analyzer::graphmatching::configs::OFFLINE;

struct Matcher {
    virtual ~Matcher() = default;
    virtual TrackSegments match(db::TrackPoints) const = 0;
    virtual std::string graphVersion() const = 0;
};

}  // namespace maps::mrc::adapters
