#pragma once

#include "maps/wikimap/mapspro/services/mrc/libs/number_recognizer/include/number_recognizer.h"

#include <opencv2/opencv.hpp>

#include <memory>
#include <vector>

namespace maps {

namespace wiki {
namespace tf_inferencer {

class FasterRCNNInferencer;

} // namespace tf_inferencer
} // namespace wiki

namespace mrc {
namespace house_number_sign_detector {

struct HouseNumberSign {
    cv::Rect box;
    float confidence;
    float confidenceDetector;
    float confidenceRecognizer;
    std::string number = "";
};

using HouseNumberSigns = std::vector<HouseNumberSign>;

enum class RecognizeNumber { Yes, No };

class FasterRCNNDetector {
public:
    FasterRCNNDetector();
    ~FasterRCNNDetector();

    HouseNumberSigns detect(const cv::Mat& image, RecognizeNumber recognizeNumber = RecognizeNumber::No) const;
    std::vector<HouseNumberSigns> detect(const std::vector<cv::Mat>& images, RecognizeNumber recognizeNumber = RecognizeNumber::No) const;
private:
    void evalHouseNumberSignID();

    int houseNumberSignClassID_;

    std::unique_ptr<wiki::tf_inferencer::FasterRCNNInferencer> tfInferencerFasterRCNN_;
    number_recognizer::NumberRecognizer numberRecognizer_;
};

number_recognizer::NumberRecognizer makeHouseNumberRecognizer();

} // house_number_sign_detector
} // namespace mrc
} // namespace maps
