#include <maps/wikimap/mapspro/services/mrc/libs/juggler/include/juggler.h>

namespace maps::mrc::juggler {

std::string toString(Level level)
{
    switch(level) {
        case Level::OK:
            return "0;OK";
        case Level::WARN:
            return "1;WARN";
        case Level::ERROR:
            return "2;ERROR";
    }
}

std::ostream& operator<<(std::ostream& out, const Message& message)
{
    return out << toString(message.level) << ": " << message.value;
}

Message ok(std::string message) { return {Level::OK, std::move(message)}; }

Message warn(std::string message) { return {Level::WARN, std::move(message)}; }

Message error(std::string message) { return {Level::ERROR, std::move(message)}; }

} // namespace maps::mrc::juggler

