#pragma once

#include <ostream>
#include <string>

namespace maps::mrc::juggler {

enum class Level {
    OK = 0,
    WARN = 1,
    ERROR = 2,
};

struct Message {
    Level level;
    std::string value;
};

std::ostream& operator<<(std::ostream& out, const Message& message);

Message ok(std::string message);
Message warn(std::string message);
Message error(std::string message);

} // namespace maps::mrc::juggler
