#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/keypoints_matcher/include/matcher.h>

#include <maps/wikimap/mapspro/services/mrc/libs/common/include/keypoints.h>

#include <utility>
#include <vector>

namespace maps::mrc::keypoints_matcher {

class MutualNNMatcher: public IKeypointsMatcher
{
public:
    MutualNNMatcher(double threshold);

    /*
        Дескрипторы должны быть единичной l2 нормы.
        Это условие не проверяется (очень ресурсозатратно) внутри,
        но существенно используется, поэтому в случае если подавать дескрипторы
        ненормализованные к единице результаты будут неправильные.
    */
    MatchedPairs match(const common::Keypoints &kpts0, const common::Keypoints &kpts1) const override;
private:
    double threshold_;
};

} // maps::mrc::keypoints_matcher