#pragma once

#include <opencv2/opencv.hpp>

#include <memory>
#include <vector>

namespace maps {

namespace wiki::tf_inferencer {

class TensorFlowInferencer;

} // namespace wiki::tf_inferencer

namespace mrc::number_recognizer {

class NumberRecognizer {
public:
    NumberRecognizer(const std::string& resourceName);
    ~NumberRecognizer();

    const std::vector<char16_t>& getSupportedSymbols() const;
    /*
        return house sign number as std::string and confidence in float
    */
    std::pair<std::string, float> recognize(const cv::Mat& image) const;
private:
    /*
        take vector of supported (can be recognized) symbols
    */
    void evalSupportedSymbols(const std::string& resourceName);
    std::vector<char16_t> supportedSymbols_;
    std::unique_ptr<wiki::tf_inferencer::TensorFlowInferencer> tfInferencer_;
};

} // mrc::number_recognizer
} // namespace maps
