#include <maps/wikimap/mapspro/services/mrc/libs/number_recognizer/include/number_recognizer.h>

#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/common/env.h>
#include <maps/libs/common/include/exception.h>

using namespace testing;

namespace maps::mrc::number_recognizer {

namespace tests {

namespace {

const std::string TF_MODEL_RESOURCE = "/maps/mrc/number_recognizer/models/fake_number_recognizer.gdef";

} //namespace

TEST(basic_tests, test_valid_symbols)
{
    NumberRecognizer recognizer(TF_MODEL_RESOURCE);
    const std::vector<char16_t>& symbols = recognizer.getSupportedSymbols();
    const std::set<char16_t> validSymbols = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    EXPECT_EQ(symbols.size(), validSymbols.size());
    for (size_t i = 0; i < symbols.size(); i++) {
        EXPECT_GT(validSymbols.count(symbols[i]), 0u);
    }
}

TEST(basic_tests, test_inference)
{
    /*
        Для тестов мы используем легкий (5 КБ) тестовый граф, который
        не распознаёт номера, а просто считает среднее значение пикселей
        в переданном изображении.
    */
    NumberRecognizer recognizer(TF_MODEL_RESOURCE);

    cv::Mat image(32, 32, CV_8UC3, cv::Scalar(42, 42, 42));

    std::pair<std::string, float> result = recognizer.recognize(image);
    std::cout << result.first << ", " << result.second << std::endl;
    EXPECT_EQ(result.first, "42");
    EXPECT_GT(result.second, 0.99);
}

} // namespace tests
} // namespace maps::mrc::number_recognizer
