#include <maps/wikimap/mapspro/services/mrc/libs/object/include/parking.h>

#include <maps/libs/common/include/exception.h>

namespace maps::mrc::object {

namespace {

const std::vector<LinearParkingLot::Type> LINEAR_PARKING_LOT_TYPES {
    LinearParkingLot::Type::UrbanRoadnetParkingFree,
    LinearParkingLot::Type::UrbanRoadnetParkingToll,
    LinearParkingLot::Type::UrbanRoadnetParkingRestricted,
    LinearParkingLot::Type::UrbanRoadnetParkingProhibited
};

bool isLinearParkingLotType(LinearParkingLot::Type type)
{
    const auto it = std::find(
        LINEAR_PARKING_LOT_TYPES.begin(), LINEAR_PARKING_LOT_TYPES.end(),
        type
    );

    return it != LINEAR_PARKING_LOT_TYPES.end();
}

} // namespace

LinearParkingLot& LinearParkingLot::type(LinearParkingLot::Type value)
{
    REQUIRE(isLinearParkingLotType(value), "Impossible ft type");

    type_ = value;
    return *this;
}

} // namespace maps::mrc::object
