#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/object.h>

#include <vector>
#include <string>

namespace maps::mrc::object {
    class AddressPointWithName: public ObjectWithGeom<geolib3::Point2> {
    public:
        AddressPointWithName(
            const RevisionID& revisionId,
            const geolib3::Point2& pt,
            const std::string& name)
            : ObjectWithGeom<geolib3::Point2>(revisionId, pt)
            , name_(name) {}
        const std::string& name() const
        {
            return name_;
        }
        std::string& name()
        {
            return name_;
        }
    private:
        std::string name_;
    };

    using AddressPointWithNames = std::vector<AddressPointWithName>;
};
