#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/object.h>

#include <maps/libs/ymapsdf/include/rd.h>

#include <vector>

namespace maps::mrc::object {

class Condition: public Object {

public:
    using Type = ymapsdf::rd::ConditionType;
    using AccessId = ymapsdf::rd::AccessId;

    using Object::Object;

    TId fromElementId() const { return fromElementId_; }
    TId viaJunctionId() const { return viaJunctionId_; }
    const TIds& toElementIds() const { return toElementIds_; } // ordered by seq_num

    Type type() const { return type_; }
    AccessId accessId() const { return accessId_; }

    constexpr bool isForCars() const { return !!(accessId_ & AccessId::Car); }

    Condition& fromElementId(TId value)
    {
        fromElementId_ = value;
        return *this;
    }

    Condition& viaJunctionId(TId value)
    {
        viaJunctionId_ = value;
        return *this;
    }

    Condition& toElementIds(TIds value)
    {
        toElementIds_ = std::move(value);
        return *this;
    }

    Condition& type(Type value)
    {
        type_ = value;
        return *this;
    }

    Condition& accessId(AccessId value)
    {
        accessId_ = value;
        return *this;
    }

private:
    TId fromElementId_{NO_OBJECT_ID};
    TId viaJunctionId_{NO_OBJECT_ID};
    TIds toElementIds_{};

    Type type_{};
    AccessId accessId_{};
};

using Conditions = std::vector<Condition>;

} // namespace maps::mrc::object
