#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/addr_points.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/building.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/common.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/condition.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/entrance.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/mrc_region.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/parking.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/rd.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/traffic_light.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/speed_bump.h>

#include <functional>
#include <memory>
#include <optional>
#include <vector>

namespace maps::mrc::object {

struct Loader {
    virtual ~Loader() = default;

    virtual RoadElements loadRoadElements(const TIds& ids) = 0;
    virtual RoadElements loadRoadElements(const geolib3::BoundingBox& mercatorBox) = 0;

    virtual ParkingLots loadParkingLots(const TIds& ids) = 0;
    virtual ParkingLots loadParkingLots(const geolib3::BoundingBox& mercatorBox) = 0;

    virtual LinearParkingLots loadLinearParkingLots(const TIds& ids) = 0;
    virtual LinearParkingLots loadLinearParkingLots(const geolib3::BoundingBox& mercatorBox) = 0;

    virtual MrcRegions loadMrcRegions(const TIds& ids) = 0;
    virtual MrcRegions loadMrcRegions(const geolib3::BoundingBox& mercatorBox) = 0;
    virtual MrcRegions loadAllMrcRegions() = 0;

    virtual RoadJunctions loadRoadJunctions(const TIds& ids) = 0;
    virtual RoadJunctions loadRoadJunctions(const geolib3::BoundingBox& mercatorBox) = 0;

    virtual Conditions loadConditions(const TIds& ids) = 0;

    virtual TrafficLights loadTrafficLights(const TIds& ids) = 0;

    virtual SpeedBumps loadSpeedBumps(const TIds& ids) = 0;

    virtual AddressPointWithNames loadAddressPointWithNames(const geolib3::BoundingBox& mercatorBox) = 0;

    virtual bool hasBuildings(const geolib3::BoundingBox& mercatorBox) = 0;
    virtual Buildings loadBuildings(const geolib3::BoundingBox& mercatorBox) = 0;

    virtual Entrances loadEntrances(const geolib3::BoundingBox& mercatorBox) = 0;
};

using LoaderHolder = std::unique_ptr<Loader>;
using LoaderFactory = std::function<LoaderHolder()>;

} // namespace maps::mrc::object
