#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/loader.h>

#include <maps/libs/geolib/include/spatial_relation.h>

#include <algorithm>
#include <iterator>
#include <tuple>
#include <vector>

namespace maps::mrc::object {

class MockLoader: public Loader {
public:
    MockLoader() = default;

    template<typename T>
    MockLoader& add(std::vector<T> from)
    {
        auto& to = std::get<std::vector<T>>(data_);

        std::move(
            from.begin(), from.end(),
            std::back_inserter(to)
        );

        return *this;
    }

    RoadElements loadRoadElements(const TIds& ids) override;
    RoadElements loadRoadElements(const geolib3::BoundingBox& mercatorBox) override;

    ParkingLots loadParkingLots(const TIds& ids) override;
    ParkingLots loadParkingLots(const geolib3::BoundingBox& mercatorBox) override;

    LinearParkingLots loadLinearParkingLots(const TIds& ids) override;
    LinearParkingLots loadLinearParkingLots(const geolib3::BoundingBox& mercatorBox) override;

    MrcRegions loadMrcRegions(const TIds& ids) override;
    MrcRegions loadMrcRegions(const geolib3::BoundingBox& mercatorBox) override;
    MrcRegions loadAllMrcRegions() override;

    RoadJunctions loadRoadJunctions(const TIds& ids) override;
    RoadJunctions loadRoadJunctions(const geolib3::BoundingBox& mercatorBox) override;

    Conditions loadConditions(const TIds& ids) override;

    TrafficLights loadTrafficLights(const TIds& ids) override;

    SpeedBumps loadSpeedBumps(const TIds& ids) override;

    AddressPointWithNames loadAddressPointWithNames(const geolib3::BoundingBox& mercatorBox) override;

    bool hasBuildings(const geolib3::BoundingBox& mercatorBox) override;
    Buildings loadBuildings(const geolib3::BoundingBox& mercatorBox) override;

    Entrances loadEntrances(const geolib3::BoundingBox& mercatorBox) override;
private:
    std::tuple<
        AddressPointWithNames,
        Buildings,
        Conditions,
        Entrances,
        LinearParkingLots,
        MrcRegions,
        ParkingLots,
        RoadElements,
        RoadJunctions,
        TrafficLights,
        SpeedBumps
    > data_{};
};

} //namespace maps::mrc::object
