#pragma once

#include <maps/libs/geolib/include/polygon.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/object.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <vector>

namespace maps::mrc::object {

class MrcRegion: public ObjectWithGeom<geolib3::Polygon2> {

public:
    enum class Type {
        Task,
        Residential,
        Restricted
    };

    using ObjectWithGeom::ObjectWithGeom;

    Type type() const { return type_; }
    MrcRegion& type(Type value)
    {
        type_ = value;
        return *this;
    }

private:
    Type type_{};
};

DECLARE_ENUM_IO(MrcRegion::Type);

using MrcRegions = std::vector<MrcRegion>;

} // namespace maps::mrc::object



