#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/common.h>

#include <unordered_map>

namespace maps::mrc::object {

constexpr TId NO_OBJECT_ID = 0;

class Object {

public:

    Object(const RevisionID& revisionId): revisionId_(revisionId) {}

    const RevisionID& revisionId() const { return revisionId_; }

    TId id() const { return revisionId().objectId(); }

protected:
    ~Object() = default;

private:
    RevisionID revisionId_;
};

template<typename TGeom>
class ObjectWithGeom: public Object {

public:
    using Geom = TGeom;

    ObjectWithGeom(const RevisionID& revisionId, const Geom& geom)
        : Object(revisionId)
        , geom_(geom)
    {}

    // Object's geometry in mercator coordinates
    const Geom& geom() const { return geom_; }

private:
    Geom geom_;
};

} // namespace maps::mrc::object
