#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/object.h>

#include <maps/libs/ymapsdf/include/ft.h>

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>

#include <vector>

namespace maps::mrc::object {

class ParkingLot: public ObjectWithGeom<geolib3::Point2> {

public:
    using ObjectWithGeom::ObjectWithGeom;
    ParkingLot(const RevisionID& revisionId, const Geom& geom, bool toll)
        : ObjectWithGeom<geolib3::Point2>(revisionId, geom)
        , toll_(toll)
    {}

    bool isToll() const { return toll_;}
    ParkingLot& setToll(bool value) {
        toll_ = value;
        return (*this);
    }
private:
    bool toll_;
};

using ParkingLots = std::vector<ParkingLot>;


class LinearParkingLot: public ObjectWithGeom<geolib3::Polyline2> {

public:
    using Type = ymapsdf::ft::Type;

    using ObjectWithGeom::ObjectWithGeom;

    Type type() const { return type_; }
    LinearParkingLot& type(Type value);

private:
    Type type_{};
};

using LinearParkingLots = std::vector<LinearParkingLot>;

} // namespace maps::mrc::object
