#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/object.h>

#include <vector>

namespace maps::mrc::object {

class SpeedBump : public Object {

public:
    using Object::Object;

    TId junctionId() const { return junctionId_; }

    const TIds& elementIds() const { return elementIds_; }

    SpeedBump& junctionId(TId value)
    {
        junctionId_ = value;
        return *this;
    }

    SpeedBump& elementIds(TIds value)
    {
        elementIds_ = std::move(value);
        return *this;
    }


private:
    TId junctionId_{NO_OBJECT_ID};
    TIds elementIds_{};
};

using SpeedBumps = std::vector<SpeedBump>;

} // namespace maps::mrc::object
