#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/object/include/object.h>

#include <vector>

namespace maps::mrc::object {

class TrafficLight: public Object {

public:
    using Object::Object;

    TId junctionId() const { return junctionId_; }

    const TIds& elementIds() const { return elementIds_; }

    TrafficLight& junctionId(TId value)
    {
        junctionId_ = value;
        return *this;
    }

    TrafficLight& elementIds(TIds value)
    {
        elementIds_ = std::move(value);
        return *this;
    }


private:
    TId junctionId_{NO_OBJECT_ID};
    TIds elementIds_{};
};

using TrafficLights = std::vector<TrafficLight>;

} // namespace maps::mrc::object
