#include <library/cpp/testing/gtest/gtest.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/mock_loader.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/rd.h>
#include <maps/libs/geolib/include/bounding_box.h>

namespace maps::mrc::object::tests {

RoadElements TEST_ROAD_ELEMENTS {
    RoadElement(
        RevisionID{1, 1},
        geolib3::Polyline2{
            geolib3::PointsVector{{0, 0}, {0, 1}, {1, 1}}
        }
    )
        .startJunctionId(2)
        .startJunctionId(3)
        .startZLevel(0)
        .endZLevel(0)
        .direction(RoadElement::Direction::Forward)
        .accessId(RoadElement::AccessId::Car)
        .speedLimit(40)
        .fc(RoadElement::FunctionalClass::MinorRoad)
        .fow(RoadElement::FormOfWay::None)
        .backTransportLane(false)
        .underConstruction(false)
        .trafficLightIds({7}),
    RoadElement(
        RevisionID{4, 1},
        geolib3::Polyline2{
            geolib3::PointsVector{{10, 10}, {10, 11}, {11, 11}}
        }
    )
        .startJunctionId(5)
        .startJunctionId(6)
        .startZLevel(0)
        .endZLevel(0)
        .direction(RoadElement::Direction::Forward)
        .accessId(RoadElement::AccessId::Car)
        .speedLimit(50)
        .fc(RoadElement::FunctionalClass::MinorRoad)
        .fow(RoadElement::FormOfWay::None)
        .backTransportLane(false)
        .underConstruction(false)
        .speedBumpIds({8}),
};

TEST(mock_loader, test_load_by_box)
{
    MockLoader loader;
    loader.add(TEST_ROAD_ELEMENTS);

    const auto elements = loader.loadRoadElements(geolib3::BoundingBox({0, 0}, {1, 1}));

    ASSERT_EQ(elements.size(), 1u);
    EXPECT_EQ(elements.front().id(), 1u);
}


TEST(mock_loader, test_load_by_id)
{
    MockLoader loader;
    loader.add(TEST_ROAD_ELEMENTS);

    const auto elements = loader.loadRoadElements(TIds{4});

    ASSERT_EQ(elements.size(), 1u);
    EXPECT_EQ(elements.front().id(), 4u);
}

TEST(mock_loader, test_load_mrc_regions)
{
    MockLoader loader;
    loader.add(
        MrcRegions{
            MrcRegion{
                RevisionID{1, 1},
                geolib3::Polygon2{
                    geolib3::PointsVector{{0, 0}, {0, 1}, {1, 1}}
                }
            },
            MrcRegion{
                RevisionID{2, 1},
                geolib3::Polygon2{
                    geolib3::PointsVector{{10, 0}, {10, 1}, {11, 1}}
                }
            }
        }
    );

    {
        const auto regions = loader.loadMrcRegions(geolib3::BoundingBox({0, 0}, {1, 1}));
        ASSERT_EQ(regions.size(), 1u);
        EXPECT_EQ(regions.front().id(), 1u);
    }

    {
        const auto regions = loader.loadAllMrcRegions();
        ASSERT_EQ(regions.size(), 2u);
    }
}

} //namespace maps::mrc::object::tests
