#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/events.h>

namespace maps::mrc::pos_improvment {

// Calculates azimuth for each gps point using gyroscope rotation speed and
// zero starting value.
// @param events should contain gps, gravity and gyro events.
std::vector<geolib3::Radians> findGyroAzimuthForEachGps(const TrackEventPtrs& events,
                                                        const GpsEvents& gpsEvents,
                                                        const GravityEvents& gravityEvents,
                                                        const GyroscopeEvents& gyroEvents);

// Returns azimuth events for each gyro events time
CarGroundDirectionEvents calculateAzimuthEvents(
    GpsEvents gpsEvents,
    const GravityEvents& gravityEvents,
    const GyroscopeEvents& gyroEvents);

} // namespace maps::mrc::pos_improvment
