#include "geom.h"

#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/distance.h>

namespace maps::mrc::pos_improvment {

Meters mercatorDistanceToMeters(double mercatorDistance, const geolib3::Point2& mercatorPoint)
{
    return Meters(geolib3::toMeters(mercatorDistance, mercatorPoint));
}

double metersToMercatorDistance(Meters meters, const geolib3::Point2& mercatorPoint)
{
    return geolib3::toMercatorUnits(meters.value(), mercatorPoint);
}

Meters distanceMeters(const geolib3::Point2 mercatorP1,
                      const geolib3::Point2 mercatorP2)
{
    return mercatorDistanceToMeters(geolib3::distance(mercatorP1, mercatorP2),
                                    mercatorP1);
}

} // namespace maps::mrc::pos_improvment
