#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/events.h>

namespace maps::mrc::pos_improvment {

// Makes azimuth values smooth. The result gps points have these propertes:
// 1) the difference between neighboring points azimuth is
//    always less than PI / 2
// 2) azimuth can have any value (not only in [0, 2PI] range)
// 3) when car moves reversely, speed is negative and azimuth directed
//    to the car front
GpsEvents smoothAzimuth(GpsEvents gpsEvents,
                        const GyroscopeEvents& gyroEvents,
                        UnitVector3 carUpVector);

// Finds speed using neighboring gps points distance
GpsEvents use2PointsGpsSpeed(GpsEvents gpsEvents);

// Finds speed using neighboring gps points distance
// Uses azimuth to find speed along correct car direction
GpsEvents use2PointsGpsSpeed(GpsEvents gpsEvents,
                             const CarGroundDirectionEvents& directionEvents);

// Finds azimuth using neighboring gps points
GpsEvents use2PointsGpsAzimuth(GpsEvents gpsEvents);

} // namespace maps::mrc::pos_improvment
