#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/events.h>

namespace maps::mrc::pos_improvment {

// Finds and returns actual gravity vector for each gyroEvent time.
// Also returns horizontal front vector of the car - it is a horizontal
// vector(in actual gravity) that is located on the same plane as the car up
// and front vectors.
std::pair<GravityEvents, CarHorizontalFrontVecEvents>
findGravityAndHorizontalFrontVector(const AccelerometerEvents& accEvents,
                                    const GyroscopeEvents& gyroEvents,
                                    const GpsEvents& gpsEvents,
                                    const UnitVector3& carUpVector,
                                    const UnitVector3& carFrontVector);

} // namespace maps::mrc::pos_improvment
