#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/events.h>

namespace maps::mrc::pos_improvment {

// Uncalibrated android gyroscope can have a constant shift.
// We assume that most of the time the phone doesn't rotate. That
// means that most of the time gyroscope should have (0, 0, 0) value.
// This function subtracts a constant value from each gyroscope event
// in such a way that the median gyroscope value is equal to (0, 0, 0)
GyroscopeEvents calibrateGyroscope(GyroscopeEvents gyroEvents);

// There can be a constant time lag between sensors and gps points. We can find
// it using CarGroundDirectionEvents(which are synchronized with sensors)
// and gps azimuth.
// Returns sensors with corrected time.
std::pair<AccelerometerEvents, GyroscopeEvents> fixSensorsAndGpsTimeLag(
    const GpsEvents& gpsEvents,
    AccelerometerEvents accEvents,
    GyroscopeEvents gyroEvents,
    const CarGroundDirectionEvents& directionEvents);

} // namespace maps::mrc::pos_improvment
