#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/events.h>

namespace maps::mrc::pos_improvment {

// Returns car up direction in the phone coordinates system
// The resulting direction may be slightly tilted to the front or to the back
// of the car
UnitVector3 findCarUpDirection(const AccelerometerEvents& accEvents);

// Returns car front direction in the phone coordinates system
// The resulting direction may be slightly tilted up or down.
// The resulting direction is perpendicular to carUpVector
UnitVector3 findCarFrontDirection(const AccelerometerEvents& accEvents,
                                  const GyroscopeEvents& gyroEvents,
                                  const GpsEvents& gpsEvents,
                                  const UnitVector3& carUpVector);

} // namespace maps::mrc::pos_improvment
