#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/events.h>

namespace maps::mrc::pos_improvment {

struct PreciseTrack {
    // Precise gps track. Distance between some neighboring points may
    // be not accurate.
    GpsEvents gpsEvents;

    // Track with bad accuracy but with precise mercator distance between
    // neighboring points.
    // Has the same .size() as gpsEvents, so odometedTrack[i] has
    // timepoint = gpsEvents[i].time
    std::vector<geolib3::Point2> odometerTrack;
};

// Returns high rate gps track with better coordinates and precise
// speed and azimuth
PreciseTrack calculatePreciseTrack(GpsEvents gpsEvents,
                                   const CarGroundDirectionEvents& directionEvents,
                                   const CarGroundSpeedEvents& speedEvents);

} // namespace maps::mrc::pos_improvment
