#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/position_improvment/include/position_improvment.h>

namespace maps::mrc::pos_improvment {


// Convert camera 3d orientation into 3 numbers and vice versa
// https://en.wikipedia.org/wiki/Rodrigues%27_rotation_formula

struct CameraOrientation {
    UnitVector3 cameraRightDirection;
    UnitVector3 cameraFrontDirection;
    UnitVector3 cameraUpDirection;
};

std::vector<double> toRodrigues(const CameraOrientation& cameraOrientation);

CameraOrientation fromRodrigues(std::vector<double> eulerAngles);

} // namespace maps::mrc::pos_improvment
