#include "caching_region_privacy.h"

#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/region_privacy.h>

namespace maps::mrc::privacy {

namespace {

std::map<db::TId, db::FeaturePrivacy>
loadDefaultGeoIdToPrivacyMap()
{
    return {
        {168, db::FeaturePrivacy::Public}, // Armenia
        {149, db::FeaturePrivacy::Public}, // Belarus
        {169, db::FeaturePrivacy::Public}, // Georgia
        {159, db::FeaturePrivacy::Public}, // Kazakhstan
        {207, db::FeaturePrivacy::Public}, // Kirgizia
        {208, db::FeaturePrivacy::Public}, // Moldova
        {225, db::FeaturePrivacy::Public}, // Russia
        // Fixme: because of a bug in Russias boundary in coverage MAPSMRC-2071
        // we added one of the regions explicitly
        {10174, db::FeaturePrivacy::Public}, // SAINT_PETERSBURG_AND_LENINGRAD_OBLAST
        {209, db::FeaturePrivacy::Public}, // Tadzikistan

        // MAPSMRC-3882 mark all regions adjacent to Ukraine Restricted privacy
        {11004, db::FeaturePrivacy::Restricted}, // Adygea
        {10645, db::FeaturePrivacy::Restricted}, // Belgorod region
        {29632, db::FeaturePrivacy::Restricted}, // Brest region
        {10650, db::FeaturePrivacy::Restricted}, // Bryanks region
        {977, db::FeaturePrivacy::Restricted}, // Crimea
        {959, db::FeaturePrivacy::Restricted}, // Sevastopol
        {29631, db::FeaturePrivacy::Restricted}, // Gomel region
        {10995, db::FeaturePrivacy::Restricted}, // Krasnodarskij region
        {10705, db::FeaturePrivacy::Restricted}, // Kursk region
        {11029, db::FeaturePrivacy::Restricted}, // Rostovskij region
        {10672, db::FeaturePrivacy::Restricted}, // Voronej region

        {181, db::FeaturePrivacy::Secret}, // Israel
    };
}


} // namespace

RegionPrivacyPtr makeCachingRegionPrivacy(
        object::Loader& loader,
        const std::string& geoIdPath,
        LockMemory lockMemory)
{
    return std::make_shared<CachingRegionPrivacy>(
        loadDefaultGeoIdToPrivacyMap(),
        loader,
        geoIdPath,
        lockMemory
    );
}

RegionPrivacyPtr makeCachingRegionPrivacy(
        object::Loader& loader,
        GeoIdProviderPtr geoIdProviderPtr)
{
    return std::make_shared<CachingRegionPrivacy>(
        loadDefaultGeoIdToPrivacyMap(),
        loader,
        std::move(geoIdProviderPtr)
    );
}

} // namespace maps::mrc::privacy
