#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/common.h>

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/prepared_polygon.h>

#include <memory>
#include <mutex>
#include <string>
#include <vector>

namespace maps::mrc::privacy {

struct GeoIdProvider {
    virtual ~GeoIdProvider() = default;

    // Returns regions that intersected by specified geometry (in area ascending order)
    virtual db::TIds load(const geolib3::Point2& geoPoint) const = 0;
    virtual db::TIds load(const geolib3::BoundingBox& geoBox) const = 0;

    virtual geolib3::MultiPolygon2 geomById(const db::TId geoId) const = 0;
};

using GeoIdProviderPtr = std::shared_ptr<GeoIdProvider>;

enum class LockMemory { No, Yes };

GeoIdProviderPtr makeGeoIdProvider(const std::string& geoIdCoveragePath,
                                   LockMemory = LockMemory::No);

} // namespace maps::mrc::privacy
