#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/geo_id_provider.h>

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/feature.h>
#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/wikimap/mapspro/services/mrc/libs/object/include/loader.h>

#include <chrono>
#include <memory>

namespace maps::mrc::privacy {

struct RegionPrivacy {
    virtual ~RegionPrivacy() = default;

    virtual db::FeaturePrivacy evalFeaturePrivacy(const geolib3::Point2& geoPoint) = 0;

    virtual db::FeaturePrivacy evalMinFeaturePrivacy(const geolib3::BoundingBox& geoBox) = 0;

    virtual db::FeaturePrivacy evalMaxFeaturePrivacy(const geolib3::BoundingBox& geoBox) = 0;
};

using RegionPrivacyPtr = std::shared_ptr<RegionPrivacy>;

RegionPrivacyPtr makeCachingRegionPrivacy(
        object::Loader& loader,
        const std::string& geoIdPath,
        LockMemory = LockMemory::No);

RegionPrivacyPtr makeCachingRegionPrivacy(
        object::Loader& loader,
        GeoIdProviderPtr geoIdProviderPtr);

} // namespace maps::mrc::privacy
