#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/privacy/impl/caching_region_privacy.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace maps::mrc::privacy {

struct MockGeoIdProvider: public GeoIdProvider {
    MOCK_METHOD(db::TIds, load, (const geolib3::Point2&), (const, override));
    MOCK_METHOD(db::TIds, load, (const geolib3::BoundingBox&), (const, override));
    MOCK_METHOD(geolib3::MultiPolygon2, geomById, (db::TId geoId), (const, override));
};

auto makeMockGeoIdProvider() {
    return std::make_unique<MockGeoIdProvider>();
}

} // namespace maps::mrc::privacy
