#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/region_privacy.h>

#include <library/cpp/testing/gmock_in_unittest/gmock.h>

namespace maps::mrc::privacy {

struct MockRegionPrivacy: public RegionPrivacy {
    MOCK_METHOD(db::FeaturePrivacy, evalFeaturePrivacy, (const geolib3::Point2&), (override));
    MOCK_METHOD(db::FeaturePrivacy, evalMinFeaturePrivacy, (const geolib3::BoundingBox&), (override));
    MOCK_METHOD(db::FeaturePrivacy, evalMaxFeaturePrivacy, (const geolib3::BoundingBox&), (override));
};

inline auto makeMockRegionPrivacy() { return std::make_unique<MockRegionPrivacy>(); }

} // namespace maps::mrc::privacy
