#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/common/env.h>
#include <maps/wikimap/mapspro/services/mrc/libs/privacy/include/geo_id_provider.h>

namespace maps::mrc::privacy::tests {

GeoIdProviderPtr makeTestGeoIdProvider()
{
    const std::string TEST_GEO_ID_PATH = BinaryPath("maps/data/test/geoid");
    return makeGeoIdProvider(TEST_GEO_ID_PATH);
}

TEST(geo_id_provider, load_by_point)
{
    const GeoIdProviderPtr provider = makeTestGeoIdProvider();

    const geolib3::Point2 MOSCOW_GEO_POINT(37.620475, 55.753981);
    const db::TIds MOSCOW_EXPECTED{213, 1, 225, 10000};

    EXPECT_EQ(provider->load(MOSCOW_GEO_POINT), MOSCOW_EXPECTED);

    const geolib3::Point2 SAINT_PETERSBURG_GEO_POINT(30.316242, 59.938971);
    const db::TIds SAINT_PETERSBURG_EXPECTED{2, 10174, 225, 10000};

    EXPECT_EQ(provider->load(SAINT_PETERSBURG_GEO_POINT), SAINT_PETERSBURG_EXPECTED);
}

TEST(geo_id_provider, load_by_box)
{
    const GeoIdProviderPtr provider = makeTestGeoIdProvider();

    const geolib3::BoundingBox BETWEEN_MOWCOW_AND_VLADIMIR_GEO_BOX(
        geolib3::Point2(38.368086, 56.074264),
        geolib3::Point2(39.804642, 55.795477)
    );
    const db::TIds EXPECTED{37129, 10669, 10742, 10745, 20523, 10658, 1, 225, 10000};

    EXPECT_EQ(provider->load(BETWEEN_MOWCOW_AND_VLADIMIR_GEO_BOX), EXPECTED);
}

} // namespace maps::mrc::browser::tests
