#pragma once

#include <maps/wikimap/mapspro/services/mrc/libs/db/include/object_in_photo.h>
#include <maps/wikimap/mapspro/services/mrc/libs/common/include/image_box.h>

#include <opencv2/opencv.hpp>

#include <memory>
#include <vector>

namespace maps {

namespace wiki {
namespace tf_inferencer {

class FasterRCNNInferencer;

} // namespace tf_inferencer
} // namespace wiki

namespace mrc {
namespace privacy_detector {

struct PrivacyImageBox {
    using Type = db::ObjectInPhotoType;

    cv::Rect box;
    db::ObjectInPhotoType type;
    float confidence;
};

using PrivacyImageBoxes = std::vector<PrivacyImageBox>;

class FasterRCNNDetector {
public:
    FasterRCNNDetector();
    ~FasterRCNNDetector();

    PrivacyImageBoxes detect(const cv::Mat& image) const;
    std::vector<PrivacyImageBoxes> detect(const std::vector<cv::Mat>& images) const;
private:
    void evalSupportedTypes();

    std::vector<PrivacyImageBox::Type> supportedTypes_;

    std::unique_ptr<wiki::tf_inferencer::FasterRCNNInferencer> tfInferencerFasterRCNN_;
};

} // privacy_detector
} // namespace mrc
} // namespace maps
