#include <library/cpp/testing/gtest/gtest.h>
#include <library/cpp/testing/common/env.h>
#include <maps/wikimap/mapspro/services/mrc/libs/privacy_detector/include/privacy_detector_faster_rcnn.h>

using namespace testing;

namespace maps::mrc::privacy_detector {

namespace tests {

namespace {

cv::Mat loadImage(const std::string& name) {
    static const std::string IMAGES_DIR =
        "maps/wikimap/mapspro/services/mrc/libs/privacy_detector/tests/data/";
    auto imagePath = static_cast<std::string>(BinaryPath(IMAGES_DIR + name));
    cv::Mat image = cv::imread(imagePath, cv::IMREAD_COLOR);
    REQUIRE(image.data != nullptr, "Can't load image " << name);
    return image;
}

} //namespace

TEST(basic_tests, detect_privacy_data_on_images)
{
    const std::string TEST_IMAGE_PATH = "privacy_detector_test_image.jpg";

    FasterRCNNDetector detector;
    cv::Mat image = loadImage(TEST_IMAGE_PATH);
    PrivacyImageBoxes objects = detector.detect(image);
    EXPECT_THAT(objects, Contains(Field(&PrivacyImageBox::type, PrivacyImageBox::Type::Face)))
        << "face not detected on image " << TEST_IMAGE_PATH;
    EXPECT_THAT(objects, Contains(Field(&PrivacyImageBox::type, PrivacyImageBox::Type::LicensePlate)))
        << "license plate not detected on image " << TEST_IMAGE_PATH;
}

TEST(basic_tests, detect_house_number_signs_on_batch)
{
    const std::string TEST_IMAGE_PATH = "privacy_detector_test_image.jpg";

    FasterRCNNDetector detector;
    std::vector<cv::Mat> batch(2);
    batch[0] = loadImage(TEST_IMAGE_PATH);
    batch[1] = cv::Mat::zeros(batch[0].size(), batch[0].type());
    std::vector<PrivacyImageBoxes> objectsBatch = detector.detect(batch);
    EXPECT_THAT(objectsBatch.size(), Eq(2ul));

    EXPECT_THAT(objectsBatch[0], Contains(Field(&PrivacyImageBox::type, PrivacyImageBox::Type::Face)))
        << "face not detected on image " << TEST_IMAGE_PATH;
    EXPECT_THAT(objectsBatch[0], Contains(Field(&PrivacyImageBox::type, PrivacyImageBox::Type::LicensePlate)))
        << "license plate not detected on image " << TEST_IMAGE_PATH;

    EXPECT_THAT(objectsBatch[1].size(), Eq(0ul));
}

} // namespace tests
} // namespace maps::mrc::privacy_detector
