#include <maps/wikimap/mapspro/services/mrc/libs/proto/include/common.h>
#include <yandex/maps/i18n.h>

namespace maps::mrc::proto {

auto makeTime(chrono::TimePoint time, const std::locale& locale)
    -> yandex::maps::proto::common2::i18n::Time
{
    return i18n::proto::encode(
        i18n::units::Time(
            std::chrono::time_point_cast<
                std::chrono::system_clock::time_point::duration>(time)),
        locale);
}

auto makeDuration(std::chrono::seconds duration, const std::locale& locale)
    -> yandex::maps::proto::common2::i18n::LocalizedValue
{
    return i18n::proto::encode(i18n::units::Duration(duration.count()), locale);
}

auto makeDistance(unsigned meters, const std::locale& locale)
    -> yandex::maps::proto::common2::i18n::LocalizedValue
{
    return i18n::proto::encode(i18n::units::Distance(meters), locale);
}

auto makeDirection(geolib3::Heading heading)
    -> yandex::maps::proto::common2::geometry::Direction
{
    auto result = yandex::maps::proto::common2::geometry::Direction{};
    result.set_azimuth(heading.value());
    result.set_tilt(0);
    return result;
}

auto makeImage(const http::URL& url,
               std::string_view sizeParam,
               const TNamedSizes& namedSizes)
    -> yandex::maps::proto::common2::Image
{
    REQUIRE(!namedSizes.empty(), "no image size");
    auto result = yandex::maps::proto::common2::Image{};
    auto os = std::ostringstream{} << url.toString()
                                   << (url.params().empty() ? "?" : "&")
                                   << sizeParam << "=%s";
    result.set_url_template(TString{os.str()});
    for (const auto& [name, size] : namedSizes) {
        auto item = result.add_size();
        item->set_size(TString{name});
        item->set_width(size.width);
        item->set_height(size.height);
    }
    return result;
}

}  // namespace maps::mrc::proto
