#include <maps/wikimap/mapspro/services/mrc/libs/common/include/exif.h>
#include <maps/wikimap/mapspro/services/mrc/libs/proto/include/named_sizes.h>

namespace maps::mrc::proto {

auto prepareNamedSizes(const db::Feature& feature) -> TNamedSizes
{
    auto originalSize = common::transformByImageOrientation(
        feature.size(), feature.orientation());
    auto thumbnailSize = common::getThumbnailSize(originalSize);
    return {{SIZE_NAME_ORIGINAL, originalSize},
            {SIZE_NAME_THUMBNAIL, thumbnailSize}};
}

}  // namespace maps::mrc::proto
